/*------------------------------------------------------------------------------*
 * File Name: UsingGetNMacros.c													*
 * Creation: GJL 6/24/2003														*
 * Purpose: Origin C file containing GetNBox example codes.						*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <GetNBox.h>

void UsingGetNMacros()
{
	// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
	GETN_TREE(tr)

	// Add a string edit box node named WksName having caption "Worksheet Name"
	// initialized to string value "Data1"
	GETN_STR(WksName, "Worksheet Name", "Data1")

	// Group following nodes in collapseable branch named Fit having caption
	// "Fitting Options"
	GETN_BEGIN_BRANCH(Fit, "Fitting Options")

		// Use macro to add a checkbox node named ThroughZero having caption
		// "Force Fit Line Through Zero" initialized to true (checked)
		GETN_CHECK(ThroughZero, "Force Fit Line Through Zero", true)

		// Add a numeric edit box node named YIntercept having caption "Y Intercept"
		// initialized to numeric value 1.5
		GETN_NUM(YIntercept, "Y Intercept", 1.5)

		// Add non-editable drop down list box node named Order having caption
		// "Polynomial Order" initialized to 2 with list values 2,3,4,5,6
		GETN_COMBO(Order, "Polynomial Order", 2, "2|3|4|5|6")

	// End nodes in collapseable branch
	GETN_END_BRANCH(Fit)

	// Add editable drop down combobox node named ColWidth having caption
	// "Column Width" initialized to 5 with list values 1,2,5,10,20,30,50
	GETN_COMBO(ColWidth, "Column Width", 5,"|1|2|5|10|20|30|50")

	// Add non-editable drop down list box node named LineColor having caption
	// "Fit Curve Color" initialized to blue with list values from the Origin color palette 
	GETN_COLOR(LineColor, "Fit Curve Color", 3)

	// Add non-editable drop down list box node named Type having caption
	// "Analysis Type" initialized to "Correlation" with list values "t-Test, Correlation," etc.
	GETN_LIST(Type, "Analysis Type", 1, "t-Test|Correlation|NLSF|Polynomial Fit|Statistics")

	// Output GetNBox tree before editing input defaults
	out_tree(tr);

	// Open GetNBox dialog and edit input defaults passing GetN tree named tr
	// and having dialog title "Using GetN Macros" and dialog description "This is
	// a GetN dialog"
	if( GetNBox(tr, "Using GetN Macros", "This is a GetN dialog") )
		out_tree(tr); // Output GetNBox tree after editing input defaults
}